[

/*

// a custom tag to get the real server name from the headers from greg willits
// use because the [server_name] tag sometimes has problems with multiple virtual hosts on the same IP
// Example: [thisServerName]

if: !(lasso_tagexists:'getServerName');
define_tag:'getServerName';
local:'host'=((string_findregexp:
		(client_headers),
		-find='(.*)HOST:(.*)',
		-ignorecase)->get:3);
	local:'subHost'=(#host->(split:'.')->(get:1));
	#host->trim;
	#subHost->trim;
return: (string: #subHost);
/define_tag;
/if;

	
//

// this protects against malicious site Cross-Site Request Forgery Attack (CSRF)
if: (string: (referrer_URL)) != ''  &&  !(string: (referrer_URL))->(Contains: (getServerName)) ;
output: '<br />Invalid Access!' ;
abort;
/if;

*/


session_start('csrf');
session_addvar('csrf','account');
session_addvar('csrf','protect');
session_addvar('csrf','token');

if(!var_defined('account'));
	var('account') = 1000;
/if;

if(!var_defined('token'));
	var('token') = lasso_uniqueid;
/if;

if(!var_defined('protect'));
	var('protect') = false;
/if;

if(action_param('protect') == 'yes');
	$protect = true;
else(action_param('protect') == 'no');
	$protect = false;
/if;


var('withdraw') = integer(action_param('withdraw'));

if($withdraw >= 0);
	if($protect);
		if(action_param('token') == $token);
			'You withdrew: ' + $withdraw + '<br>';
			$account -= $withdraw;
		/if;
	else;
		'You withdrew: ' + $withdraw + '<br>';
		$account -= $withdraw;	
	/if;
/if;

]

Balance: [$account]

<form>
<input type="hidden" name="token" value="[$token]">
Withdraw: <input type="text" name="withdraw"><br>
<br>
Protect against attack? <select name="protect"><option[if($protect);' SELECTED';/if]>Yes<option[if(!$protect);' SELECTED';/if]>No</select>
<br>
<br>
<input type="submit" value="submit" name="submit">
</form>

<a href="http://xxx.dev.xxx/csrf-attack.html">Visit malicious site</a>

<br><br>
<em>original cross-site request forgery example from Bill Corry at the 2008 Lasso Developer Conference</em>